#ifndef __CMenuEvent__
#define __CMenuEvent__

#include <Basics/CCountedObject.hpp>
#include "../Controls/CMenuItem.hpp"
#include "../Controls/CMenu.hpp"

//	===========================================================================

using Exponent::Basics::CCountedObject;
using Exponent::GUI::Controls::CMenuItem;
using Exponent::GUI::Controls::CMenu;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Events
		{
			/**
			 * @class CMenuEvent CMenuEvent.hpp
			 * @brief Allows for responding to menu actions
			 *
			 * @date 15/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CMenuEvent.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			class CMenuEvent : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param item The item that was selected
				 * @param menu The owner menu
				 */
				CMenuEvent(CMenuItem *item, CMenu *menu);

				/**
				 * Destruction
				 */
				virtual ~CMenuEvent();

//	===========================================================================

				/**
				 * Get the id
				 * @retval long The id of the menu item
				 */
				long identify() const;

				/**
				 * Get the menu item
				 * @retval CMenuItem* The menu item
				 */
				CMenuItem *getMenuItem() const;

				/**
				 * Get the menu
				 * @retval CMenu* The menu
				 */
				CMenu *getMenu() const;

//	===========================================================================

				/**
				 * Set the menu item
				 * @param item The menu item
				 */
				void setMenuItem(CMenuItem *item);

				/**
				 * Set the menu
				 * @param menu The menu
				 */
				void setMenu(CMenu *menu);

//	===========================================================================

			protected:

//	===========================================================================

				CMenuItem *m_menuItem;			/**< The menu item that generated the event */
				CMenu *m_menu;					/**< The owning menu */

			};
		}
	}
}
#endif	// End of CMenuEvent.hpp